//	CFolder.h

#ifndef _H_CFolder
#define _H_CFolder

#ifndef __GNUC__
	#include "Drag.h"
#endif

#include "CEntry.h"

typedef struct {
	short				dirIndexS;
	Boolean				normalB;
	Boolean				deletedB;
	ulong				blocksInVolumeL;
	ushort				headerBlockS;
} Gen_MakeEntryData;

class CFolder : public CEntry {
	
	public:
	
	OSErr		IFolder(
		CDisk				*cDisk, 
		CFolder				*cParentFolder, 	//	if cParentFolder is NULL, then this is root
		DiskLocSpecUnion	diskLoc, 
		EntryIndex			diskLocDirEntryIndex,	//	relative to cur dir sector
		EntryIndex			directoryIndex			//	relative to entire directory
	);

	virtual		Err		EntryDispatchCB(
		O_CBType			cbType, 
		O_CBDataP			cbData);

	virtual ADFS_IconType	GetIconType(void);
	virtual	OSErr			NewFile(Boolean isFolder, CEntry **entryH);
	virtual	ushort			GetFileType_ProEquiv(void);

	virtual	EntryIndex		CountEntries(void);
	virtual	CEntry			*GetIndEntry(EntryIndex entryIndex);

	virtual	OSErr			CanAcceptFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		Boolean			*goodFlavorB);
		
	virtual	OSErr			DragReceiveFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		void			*data);

	virtual	Boolean		GetUniqueName(char* fileName);
	virtual	void		ConformStrLen(char* nameStr);
	

	virtual	OSErr		OffsetEachFile(
		CFile		*firstFileP, 
		CFile		*lastFileP, 
		short		offsetL);

	virtual	OSErr		DeleteFolderContents(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr		UnDeleteFolderContents(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);

	virtual	OSErr		MoveFile(CEntry *srcEntryP, CEntry *dstEntryP);
	virtual	OSErr		NewFolder(CEntry **newFolderH);
	
	CEntryArray			*GetDirectory(void);
	
	CEntry				*FindByName_C(char *nameZ);
	virtual	void		UnCacheFolderSizes(void);

	virtual	OSErr		AddEntries(Boolean normalB, Boolean deletedB);
	virtual	OSErr		ToggleDeletedFiles(void);
	virtual	Boolean		IsLocked(void);

	OSErr		Reorder(
		O_TopicIndex	oldIndex,
		O_TopicIndex	newIndex);

	virtual	OSErr 		CB_DirSort(
		ADFS_StatType	sortBy, 
		CEntry 			*a, 
		CEntry 			*b, 
		long			*resultL);

	OSErr		Sort(ADFS_StatType sortBy, Boolean recursiveB = FALSE);
	OSErr		UpdateSort(Boolean recursiveB = FALSE);

	virtual	OSErr		CountRecurse(Boolean deletedB, ulong *totalL);

	private:
	typedef CEntry _inherited;
};

#endif
